IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_PROD_REM_PRE_VENC_IT_LOTE') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT_LOTE](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_REMESSA] [int] NOT NULL,
	[CD_LOTE] [int] NOT NULL,
	[EAN] [varchar](20) NULL,
	[CD_TBL_DESC] [int] NULL,
	[DEVOLUCAO_FORN] [tinyint] NULL,
 CONSTRAINT [PK_EST_PROD_REM_PRE_VENC_IT_LOTE] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_REMESSA] ASC,
	[CD_LOTE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT_LOTE] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_LOTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT_LOTE] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_LOTE_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT_LOTE] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_LOTE_CD_REMESSA]  DEFAULT ((0)) FOR [CD_REMESSA]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT_LOTE] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_LOTE_CD_LOTE]  DEFAULT ((0)) FOR [CD_LOTE]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT_LOTE]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_IT_LOTE_EST_PROD_CPL_LOTE] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_LOTE])
REFERENCES [dbo].[EST_PROD_CPL_LOTE] ([CD_EMP], [CD_FILIAL], [CD_LOTE])

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT_LOTE] CHECK CONSTRAINT [FK_EST_PROD_REM_PRE_VENC_IT_LOTE_EST_PROD_CPL_LOTE]
END